
import { useSetAppSearch } from "@/components/routes/app-route.hooks";
import { MenuItemProps, MenuCheckboxItem } from "@/components/ui/primitives/menu-item";
import { env } from "@/env.setup";
import { useAppFilter } from "@/hooks/use-app-filter";

export function CountyLayerFilterItem({ variant }: MenuItemProps) {
    const { set } = useSetAppSearch()
    const { isCountyFilterEnabled } = useAppFilter();

    return (
        <MenuCheckboxItem
            variant={variant}
            checked={isCountyFilterEnabled}
            disabled={env.MODE !== "development"}
            onClick={() => {
                set({
                    f: {
                        counties: !isCountyFilterEnabled
                    }
                })
            }}
        >
            Show County Regions
        </MenuCheckboxItem>
    )
}